#!/bin/sh
# Purepose:
#		This file holds obsolete code

display_version_page() {
	debug_print "${0}" "${LINENO}" 'in function "display_version_page"'

	local VERINFO_PATH="${MS_INSTALL_PATH}""version.txt"
	local DTAS_VER=`cat "${VERINFO_PATH}"`
	dialog --backtitle "${BACK_TITLE}" --msgbox "${DTAS_VER}" 7 30
}

display_license_info_page() {
	debug_print "${0}" "${LINENO}" 'in function "display_license_info_page"'
    local expire_date=`php $BACKEND license_controller "${DTASCFG_XML_FILE}" GET`

    dialog --backtitle "${BACK_TITLE}" --msgbox "${LICENSE_INFO_CONFIGURATION_PAGE_EXPIRE_DATE} ${expire_date}" 7 70
}

preconfigure_page() {
	debug_print "${0}" "${LINENO}" 'in function "preconfigure_page"'
	
	exec 3>&1
	local ret=`dialog \
		--backtitle "${BACK_TITLE}" \
		--ok-label "${OK_LABEL}" \
		--title "${PRECONFIGURE_PAGE_TITLE}" \
		--msgbox "${PRECONFIGURE_PAGE_SUBTITLE}" "${box_height}" "${box_width}" \
		2>&1 1>&3; \
		case "${?}" in \
			255) echo "${DIALOG_RETURN_CODE_ESC}"; ;; \
		esac \
		`
	exec 3>&-

	case "${ret}" in
		"${DIALOG_RETURN_CODE_ESC}")		page_result="${WIZARD_ACTION_STAY}"; return; ;;
	esac

	page_result="${WIZARD_ACTION_NEXT}"
}

function _proxy_network_configuration_radio_on_off() {
	local item=$1
	local current_value=$2
	local result=""
	
	case "$item" in
		"$PROXY_NETWORK_CONFIGURATION_STRING_USE_PROXY")
			[ "$current_value" -eq 0 ] && result="off" || result="on"
			;;
			
		"$PROXY_NETWORK_CONFIGURATION_STRING_NO_PROXY")
			[ "$current_value" -eq 0 ] && result="on" || result="off"
			;;
			
		"$PROXY_NETWORK_CONFIGURATION_STRING_HTTP")
			current_value=`echo "$current_value" | tr "[a-z]" "[A-Z]"`
			[ "$current_value" == "HTTP" ] && result="on" || result="off"
			;;
			
		"$PROXY_NETWORK_CONFIGURATION_STRING_SOCKS4")
			current_value=`echo "$current_value" | tr "[a-z]" "[A-Z]"`
			[ "$current_value" == "SOCKS4" ] && result="on" || result="off"
			;;
			
		"$PROXY_NETWORK_CONFIGURATION_STRING_SOCKS5")
			current_value=`echo "$current_value" | tr "[a-z]" "[A-Z]"`
			[ "$current_value" == "SOCKS5" ] && result="on" || result="off"
			;;
			
		"$PROXY_NETWORK_CONFIGURATION_STRING_AUTHENTICATE")
			[ "$current_value" -eq 0 ] && result="off" || result="on"
			;;
			
		"$PROXY_NETWORK_CONFIGURATION_STRING_NONAUTHENTICATE")
			[ "$current_value" -eq 0 ] && result="on" || result="off"
			;;
	esac
	
	echo "$result"
}

function _proxy_network_configuration_sub_page_use_proxy() {
	debug_print "${0}" "${LINENO}" 'in function "_proxy_network_configuration_sub_page_use_proxy"'

	local use_proxy_default_on_off=`_proxy_network_configuration_radio_on_off \
		"$PROXY_NETWORK_CONFIGURATION_STRING_USE_PROXY" \
		"$use_proxy"`
		
	local no_proxy_default_on_off=`_proxy_network_configuration_radio_on_off \
		"$PROXY_NETWORK_CONFIGURATION_STRING_NO_PROXY" \
		"$use_proxy"`
	
	exec 3>&1
	local ret=`dialog \
		--backtitle    "$BACK_TITLE" \
		--title        "$PROXY_NETWORK_CONFIGURATION_PAGE_TITLE" \
		--ok-label     "$OK_LABEL" \
		--cancel-label "$CANCEL_LABEL" \
		--radiolist    "$PROXY_NETWORK_CONFIGURATION_SUBPAGE_USE_PROXY_SUBTITLE" "$box_height" "$box_width" 0 \
		\
		"$PROXY_NETWORK_CONFIGURATION_STRING_USE_PROXY" "" "$use_proxy_default_on_off" \
		"$PROXY_NETWORK_CONFIGURATION_STRING_NO_PROXY"  "" "$no_proxy_default_on_off" \
		\
		2>&1 1>&3; \
		case "${?}" in \
			1)   echo "$DIALOG_RETURN_CODE_CANCEL" ;; \
			255) echo "$DIALOG_RETURN_CODE_ESC" ;; \
		esac`
	exec 3>&-

	case "$ret" in

		# when user presses "BACK" or "ESC"
		"$DIALOG_RETURN_CODE_CANCEL" | "$DIALOG_RETURN_CODE_ESC")
			proxy_network_configuration_page_index=0
			page_result="$WIZARD_ACTION_BACK"
			;;

		
		# when user choose "USE_PROXY"
		"$PROXY_NETWORK_CONFIGURATION_STRING_USE_PROXY")
			use_proxy="1"
			debug_print "${0}" "${LINENO}" "get use_proxy from dialog: $use_proxy"
			
			proxy_network_configuration_page_index=$(( $proxy_network_configuration_page_index + 1 ))
			;;


		# when user choose "NO_PROXY"
		"$PROXY_NETWORK_CONFIGURATION_STRING_NO_PROXY")
			use_proxy="0"
			debug_print "${0}" "${LINENO}" "get use_proxy from dialog: $use_proxy"
			
			proxy_network_configuration_page_index=0
			page_result="$WIZARD_ACTION_NEXT"
			;;
	esac
}

function _proxy_network_configuration_sub_page_choose_protocol() {
	debug_print "${0}" "${LINENO}" 'in function "_proxy_network_configuration_sub_page_choose_protocol"'

	local http_protocol_default_on_off=`_proxy_network_configuration_radio_on_off \
		"$PROXY_NETWORK_CONFIGURATION_STRING_HTTP" \
		"$proxy_protocol"`
		
	local socks4_protocol_default_on_off=`_proxy_network_configuration_radio_on_off \
		"$PROXY_NETWORK_CONFIGURATION_STRING_SOCKS4" \
		"$proxy_protocol"`
	
	local socks5_protocol_default_on_off=`_proxy_network_configuration_radio_on_off \
		"$PROXY_NETWORK_CONFIGURATION_STRING_SOCKS5" \
		"$proxy_protocol"`

		exec 3>&1
	local ret=`dialog \
		--backtitle    "$BACK_TITLE" \
		--title        "$PROXY_NETWORK_CONFIGURATION_PAGE_TITLE" \
		--ok-label     "$OK_LABEL" \
		--cancel-label "$CANCEL_LABEL" \
		--radiolist    "$PROXY_NETWORK_CONFIGURATION_SUBPAGE_CHOOSE_PROTOCOL_SUBTITLE" "$box_height" "$box_width" 0 \
		\
		"$PROXY_NETWORK_CONFIGURATION_STRING_HTTP"   "" "$http_protocol_default_on_off" \
		"$PROXY_NETWORK_CONFIGURATION_STRING_SOCKS4" "" "$socks4_protocol_default_on_off" \
		"$PROXY_NETWORK_CONFIGURATION_STRING_SOCKS5" "" "$socks5_protocol_default_on_off" \
		\
		2>&1 1>&3; \
		case "${?}" in \
			1)   echo "$DIALOG_RETURN_CODE_CANCEL" ;; \
			255) echo "$DIALOG_RETURN_CODE_ESC" ;; \
		esac`
	exec 3>&-

	case "$ret" in

		# when user presses "BACK" or "ESC"
		"$DIALOG_RETURN_CODE_CANCEL" | "$DIALOG_RETURN_CODE_ESC")
			proxy_network_configuration_page_index=$(( $proxy_network_configuration_page_index - 1 ))
			;;

		
		# when user choose "HTTP"
		"$PROXY_NETWORK_CONFIGURATION_STRING_HTTP")
			proxy_protocol="http"
			debug_print "${0}" "${LINENO}" "get proxy_protocol from dialog: $proxy_protocol"
			
			proxy_network_configuration_page_index=$(( $proxy_network_configuration_page_index + 1 ))
			;;


		# when user choose "SOCKS4"
		"$PROXY_NETWORK_CONFIGURATION_STRING_SOCKS4")
			proxy_protocol="socks4"
			debug_print "${0}" "${LINENO}" "get proxy_protocol from dialog: $proxy_protocol"
			
			proxy_network_configuration_page_index=$(( $proxy_network_configuration_page_index + 1 ))
			;;


		# when user choose "SOCKS5"
		"$PROXY_NETWORK_CONFIGURATION_STRING_SOCKS5")
			proxy_protocol="socks5"
			debug_print "${0}" "${LINENO}" "get proxy_protocol from dialog: $proxy_protocol"
			
			proxy_network_configuration_page_index=$(( $proxy_network_configuration_page_index + 1 ))
			;;
	esac
}

function _proxy_network_configuration_sub_page_use_authentication() {
	debug_print "${0}" "${LINENO}" 'in function "_proxy_network_configuration_sub_page_use_authentication"'

	local authenticate_default_on_off=`_proxy_network_configuration_radio_on_off \
		"$PROXY_NETWORK_CONFIGURATION_STRING_AUTHENTICATE" \
		"$proxy_network_configuration_page_use_authenticate"`
		
	local nonauthenticate_default_on_off=`_proxy_network_configuration_radio_on_off \
		"$PROXY_NETWORK_CONFIGURATION_STRING_NONAUTHENTICATE" \
		"$proxy_network_configuration_page_use_authenticate"`
	
	exec 3>&1
	local ret=`dialog \
		--backtitle    "$BACK_TITLE" \
		--title        "$PROXY_NETWORK_CONFIGURATION_PAGE_TITLE" \
		--ok-label     "$OK_LABEL" \
		--cancel-label "$CANCEL_LABEL" \
		--radiolist    "$PROXY_NETWORK_CONFIGURATION_SUBPAGE_USE_AUTHENTICATION_SUBTITLE" "$box_height" "$box_width" 0 \
		\
		"$PROXY_NETWORK_CONFIGURATION_STRING_AUTHENTICATE"    "" "$authenticate_default_on_off" \
		"$PROXY_NETWORK_CONFIGURATION_STRING_NONAUTHENTICATE" "" "$nonauthenticate_default_on_off" \
		\
		2>&1 1>&3; \
		case "${?}" in \
			1)   echo "$DIALOG_RETURN_CODE_CANCEL" ;; \
			255) echo "$DIALOG_RETURN_CODE_ESC" ;; \
		esac`
	exec 3>&-

	case "$ret" in

		# when user presses "BACK" or "ESC"
		"$DIALOG_RETURN_CODE_CANCEL" | "$DIALOG_RETURN_CODE_ESC")
			proxy_network_configuration_page_index=$(( $proxy_network_configuration_page_index - 1 ))
			;;

		
		# when user choose "AUTHENTICATE"
		"$PROXY_NETWORK_CONFIGURATION_STRING_AUTHENTICATE")
			proxy_network_configuration_page_use_authenticate="1"
			debug_print "${0}" "${LINENO}" "get use_authenticate from dialog: $proxy_network_configuration_page_use_authenticate"
			
			proxy_network_configuration_page_index=$(( $proxy_network_configuration_page_index + 1 ))
			;;


		# when user choose "NONAUTHENTICATE"
		"$PROXY_NETWORK_CONFIGURATION_STRING_NONAUTHENTICATE")
			proxy_network_configuration_page_use_authenticate="0"
			debug_print "${0}" "${LINENO}" "get use_authenticate from dialog: $proxy_network_configuration_page_use_authenticate"
			
			proxy_network_configuration_page_index=$(( $proxy_network_configuration_page_index + 1 ))
			;;
	esac
}

function _proxy_network_configuration_sub_page_input_proxy_information() {
	debug_print "${0}" "${LINENO}" 'in function "_proxy_network_configuration_sub_page_input_proxy_information"'

	if [ -n $proxy ]; then
		local proxy_ip_segment1=`echo "$proxy" | cut -f1 -d"."`
		local proxy_ip_segment2=`echo "$proxy" | cut -f2 -d"."`
		local proxy_ip_segment3=`echo "$proxy" | cut -f3 -d"."`
		local proxy_ip_segment4=`echo "$proxy" | cut -f4 -d"."`
	fi

	local ret=""
	exec 3>&1	
	if [ "$proxy_network_configuration_page_use_authenticate" -eq 1 ]; then
		ret=`dialog \
			--backtitle    "$BACK_TITLE" \
			--title        "$PROXY_NETWORK_CONFIGURATION_PAGE_TITLE" \
			--ok-label     "$OK_LABEL" \
			--cancel-label "$CANCEL_LABEL" \
			--insecure \
			--mixedform    "$PROXY_NETWORK_CONFIGURATION_SUBPAGE_INPUT_PROXY_INFORMATION_SUBTITLE" \
			18 "${box_width}" 11 \
			"$PROXY_NETWORK_CONFIGURATION_STRING_IP_ADDRESS" 1  0 "$proxy_ip_segment1" 1 12 4 3 0 \
			""                                               1 24 "."                  1 16 2 2 2 \
			""                                               1 25 "$proxy_ip_segment2" 1 17 4 3 0 \
			""                                               1 29 "."                  1 21 2 2 2 \
			""                                               1 30 "$proxy_ip_segment3" 1 22 4 3 0 \
			""                                               1 34 "."                  1 26 2 2 2 \
			""                                               1 35 "$proxy_ip_segment4" 1 27 4 3 0 \
			\
			"$PROXY_NETWORK_CONFIGURATION_STRING_PORT" 3 0 "$proxy_port"     3 12  6  5 0 \
			"$ESXI_CONFIGURATION_PAGE_USERNAME_STRING" 5 0 "$proxy_username" 5 12 19 18 0 \
			"$ESXI_CONFIGURATION_PAGE_PASSWORD_STRING" 7 0 "$proxy_password" 7 12 19 18 1 \
			2>&1 1>&3; \
			case "${?}" in \
				1)   echo "$DIALOG_RETURN_CODE_CANCEL" ;; \
				255) echo "$DIALOG_RETURN_CODE_ESC" ;; \
			esac`
	else
		ret=`dialog \
			--backtitle    "$BACK_TITLE" \
			--title        "$PROXY_NETWORK_CONFIGURATION_PAGE_TITLE" \
			--ok-label     "$OK_LABEL" \
			--cancel-label "$CANCEL_LABEL" \
			--insecure \
			--mixedform    "$PROXY_NETWORK_CONFIGURATION_SUBPAGE_INPUT_PROXY_INFORMATION_SUBTITLE" \
			16 "${box_width}" 9 \
			"$PROXY_NETWORK_CONFIGURATION_STRING_IP_ADDRESS" 1  0 "$proxy_ip_segment1" 1 12 4 3 0 \
			""                                               1 24 "."                  1 16 2 2 2 \
			""                                               1 25 "$proxy_ip_segment2" 1 17 4 3 0 \
			""                                               1 29 "."                  1 21 2 2 2 \
			""                                               1 30 "$proxy_ip_segment3" 1 22 4 3 0 \
			""                                               1 34 "."                  1 26 2 2 2 \
			""                                               1 35 "$proxy_ip_segment4" 1 27 4 3 0 \
			\
			"$PROXY_NETWORK_CONFIGURATION_STRING_PORT" 3 0 "$proxy_port"     3 12  6  5 0 \
			2>&1 1>&3; \
			case "${?}" in \
				1)   echo "${DIALOG_RETURN_CODE_CANCEL}"; ;; \
				255) echo "${DIALOG_RETURN_CODE_ESC}"; ;; \
			esac`
	fi
	exec 3>&-

	case "$ret" in

		# when user presses "BACK" or "ESC"
		"$DIALOG_RETURN_CODE_CANCEL" | "$DIALOG_RETURN_CODE_ESC")
			proxy_network_configuration_page_index=$(( $proxy_network_configuration_page_index - 1 ))
			;;

		
		# when user presses "NEXT"
		*)
		
			# handle proxy 
			local proxy_ip_segment1=`echo "$ret" | sed -n '1p'`
			local proxy_ip_segment2=`echo "$ret" | sed -n '3p'`
			local proxy_ip_segment3=`echo "$ret" | sed -n '5p'`
			local proxy_ip_segment4=`echo "$ret" | sed -n '7p'`
			proxy="$proxy_ip_segment1.$proxy_ip_segment2.$proxy_ip_segment3.$proxy_ip_segment4"
			debug_print "${0}" "${LINENO}" "check if valid: $proxy ..."
			if ! $(is_ip_valid "$proxy") ; then
				debug_print "${0}" "${LINENO}" "invalid IP: $proxy"
				
				warning "$ERROR_STRING_INVALID_ARGUMENT" "$proxy"
				return
			fi
			debug_print "${0}" "${LINENO}" "get proxy from dialog: $proxy"			

			
			# handle proxy port
			proxy_port=`echo "$ret" | sed -n '8p'`
			debug_print "${0}" "${LINENO}" "check if valid: $proxy_port ..."
			if ! $(is_port_number_valid "$proxy_port") ; then
				debug_print "${0}" "${LINENO}" "invalid port number: $proxy_port"
				
				warning "$ERROR_STRING_INVALID_ARGUMENT" "$proxy_port"
				return
			fi
			debug_print "${0}" "${LINENO}" "get proxy_port from dialog: $proxy_port"

			
			# when choose "use authenticate proxy", handle username and password
			if [ "$proxy_network_configuration_page_use_authenticate" -eq 1 ]; then
				debug_print "${0}" "${LINENO}" "user chooses to use authenticate proxy"
				
				proxy_username=`echo "$ret" | sed -n '9p'`
				debug_print "${0}" "${LINENO}" "check if valid: $proxy_username ..."
				if ! $(is_username_valid "$proxy_username") ; then
					debug_print "${0}" "${LINENO}" "invalid Username: $proxy_username"
					
					warning "${ERROR_STRING_INVALID_ARGUMENT}" "$proxy_username"
					return
				fi
				debug_print "${0}" "${LINENO}" "get proxy_username from dialog: $proxy_username"

				
				proxy_password=`echo "$ret" | sed -n '10p'`
				if ! $(is_password_valid "$proxy_password") ; then
					debug_print "${0}" "${LINENO}" "invalid password"
					
					warning "${ERROR_STRING_INVALID_ARGUMENT}" "invalid password"
					return
				fi

				debug_print "${0}" "${LINENO}" "get proxy_password from dialog: <hidden>"
				
			else
				debug_print "${0}" "${LINENO}" "user chooses to use non-authenticate proxy"
				
				proxy_username=""
				proxy_password=""
				debug_print "${0}" "${LINENO}" "clear proxy_username and proxy_password"
			fi

			
			# save proxy network configuration
			debug_print "${0}" "${LINENO}" "calling \"save_proxy_network_configuration\""
			save_proxy_network_configuration
			local tmp_return_code=$?
			if [ "$tmp_return_code" -ne 0 ]; then
				debug_print "${0}" "${LINENO}" "fail to save_proxy_network_configuration: $tmp_return_code"
			fi

			proxy_network_configuration_page_index="0"
			page_result="$WIZARD_ACTION_NEXT"
			;;
	esac
}

proxy_network_configuration_page() {
	debug_print "${0}" "${LINENO}" 'in function "proxy_network_configuration_page"'
	
	local proxy_network_configuration_page_index=1
	local proxy_network_configuration_page_use_authenticate=`[ -z $proxy_username ] && echo "0" || echo "1"`
	while [ 1 ];
	do
		case "$proxy_network_configuration_page_index" in
			0) break ;;
			1) _proxy_network_configuration_sub_page_use_proxy ;;
			2) _proxy_network_configuration_sub_page_choose_protocol ;;
			3) _proxy_network_configuration_sub_page_use_authentication ;;
			4) _proxy_network_configuration_sub_page_input_proxy_information ;;
		esac
	done
	
	return 0
}

after_deployment_proxy_network_configuration_page() {
	debug_print "${0}" "${LINENO}" 'in function "after_deployment_proxy_network_configuration_page"'
	
	debug_print "${0}" "${LINENO}" "calling \"proxy_network_configuration_page\""
	proxy_network_configuration_page
	
	
	if [ "$page_result" != "$WIZARD_ACTION_NEXT" ]; then
		return
	fi
	
	
	# when user presses "NEXT"
	save_proxy_network_configuration
}

setup_syslog() {
	debug_print "${0}" "${LINENO}" 'in function "setup_syslog"'
	
    local syslog_server=`php "${CEF_LOG_SENDER_DIR}"/xpath.php "${DTASCFG_XML_FILE}" configuration cef_log_sender syslog_server`
    local syslog_port=`php "${CEF_LOG_SENDER_DIR}"/xpath.php "${DTASCFG_XML_FILE}" configuration cef_log_sender syslog_server_listen_port`

    exec 3>&1
    local ret=`dialog --backtitle "${BACK_TITLE}" \
            --form "${SYSLOG_CONFIGURATION_PAGE_SERVER_SETTING}" 15 50 5 \
            "${SYSLOG_CONFIGURATION_PAGE_ADDRESS}" 2 4 "${syslog_server}" 2 15 20 0\
            "${SYSLOG_CONFIGURATION_PAGE_PORT}" 4 4 "${syslog_port}" 4 15 20 0\
            2>&1 1>&3`
    exec 3>&-

    php "${CEF_LOG_SENDER_DIR}"/Controller.php -x "${DTASCFG_XML_FILE}" -s `echo $ret | cut -d ' ' -f1`
    php "${CEF_LOG_SENDER_DIR}"/Controller.php -x "${DTASCFG_XML_FILE}" -p `echo $ret | cut -d ' ' -f2`
}

syslog_configuration_page() {
	debug_print "${0}" "${LINENO}" 'in function "syslog_configuration_page"'
	
    local ret=`php "${CEF_LOG_SENDER_DIR}"/xpath.php "${DTASCFG_XML_FILE}" configuration cef_log_sender enable`

    case $ret in
    0)
        val1="off"
        val2="on"
        ;;
    1)
        val1="on"
        val2="off"
        ;;
    esac

    exec 3>&1
    local ret=`dialog \
        --backtitle "${BACK_TITLE}" \
        --radiolist "${SYSLOG_CONFIGURATION_PAGE_SEND_LOG}" \
        15 35 2 0 \
        "${SYSLOG_CONFIGURATION_PAGE_ENABLE}" "${val1}" 1 \
        "${SYSLOG_CONFIGURATION_PAGE_DISABLE}" "${val2}" \
        2>&1 1>&3`
    exec 3>&-

    case $ret in
    0)
        #disable syslog setting in dtascfg.xml
        php "${CEF_LOG_SENDER_DIR}"/Controller.php -x "${DTASCFG_XML_FILE}" -e 1
        setup_syslog
        ;;
    1)
        #enable syslog setting in dtascfg.xml
        php "${CEF_LOG_SENDER_DIR}"/Controller.php -x "${DTASCFG_XML_FILE}" -e 0
        ;;
    esac
}

